/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.helper;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import tschipp.carryon.common.handler.ModelOverridesHandler;
import tschipp.carryon.common.helper.ScriptParseHelper;
import tschipp.carryon.common.scripting.CarryOnOverride;

public class CarryRenderHelper {
    public static Vec3 getExactPos(Entity entity, float partialticks) {
        return new Vec3(entity.f_19790_ + (entity.m_20185_() - entity.f_19790_) * (double)partialticks, entity.f_19791_ + (entity.m_20186_() - entity.f_19791_) * (double)partialticks, entity.f_19792_ + (entity.m_20189_() - entity.f_19792_) * (double)partialticks);
    }

    public static float getExactBodyRotationDegrees(LivingEntity entity, float partialticks) {
        if (entity.m_20202_() != null && entity.m_20202_() instanceof LivingEntity) {
            return -(entity.f_20886_ + (entity.f_20885_ - entity.f_20886_) * partialticks);
        }
        return -(entity.f_20884_ + (entity.f_20883_ - entity.f_20884_) * partialticks);
    }

    public static Quaternion getExactBodyRotation(LivingEntity entity, float partialticks) {
        return Vector3f.f_122225_.m_122240_(CarryRenderHelper.getExactBodyRotationDegrees(entity, partialticks));
    }

    public static void performOverrideTransformation(PoseStack matrix, CarryOnOverride override) {
        int perspective = CarryRenderHelper.getPerspective();
        float[] translation = ScriptParseHelper.getXYZArray(override.getRenderTranslation());
        float[] rotation = ScriptParseHelper.getXYZArray(override.getRenderRotation());
        float[] scaled = ScriptParseHelper.getScaled(override.getRenderScaled());
        Quaternion rot = Vector3f.f_122223_.m_122240_(rotation[0]);
        rot.m_80148_(Vector3f.f_122225_.m_122240_(rotation[1]));
        rot.m_80148_(Vector3f.f_122227_.m_122240_(rotation[2]));
        matrix.m_85845_(rot);
        matrix.m_85837_((double)translation[0], (double)translation[1], perspective == 1 && override.isBlock() ? (double)(-translation[2]) : (double)translation[2]);
        matrix.m_85841_(scaled[0], scaled[1], scaled[2]);
    }

    public static void renderItem(BlockState state, CompoundTag tag, ItemStack stack, ItemStack tileStack, PoseStack matrix, MultiBufferSource buffer, int light, BakedModel model) {
        Object override;
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        if (ModelOverridesHandler.hasCustomOverrideModel(state, tag) && (override = ModelOverridesHandler.getOverrideObject(state, tag)) instanceof ItemStack) {
            renderer.m_115143_((ItemStack)override, ItemTransforms.TransformType.NONE, false, matrix, buffer, light, OverlayTexture.f_118083_, model);
            return;
        }
        renderer.m_115143_(tileStack.m_41619_() ? stack : tileStack, ItemTransforms.TransformType.NONE, false, matrix, buffer, light, OverlayTexture.f_118083_, model);
    }

    public static int getPerspective() {
        boolean isThirdPerson = !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_();
        boolean isThirdPersonReverse = Minecraft.m_91087_().f_91066_.m_92176_().m_90613_();
        if (!isThirdPerson && !isThirdPersonReverse) {
            return 0;
        }
        if (isThirdPerson && !isThirdPersonReverse) {
            return 1;
        }
        return 2;
    }
}

